# 字符串格式化

C# 提供了丰富的字符串格式化支持。

* 普通字符串可以使用`\`来做转义
* 支持插入 Unicode 编码
* 使用 `@"23六jlqkjr"` 风格可以实现逐字文本输出
* 使用 `$"{variable_name}"` 风格可以在字符串内插入变量

以下格式化代码，能正确运行的有哪些？

一：

```csharp
Console.WriteLine("{\"err\":\"success\", \"value\":\"C#之父: 安德斯·海尔斯伯格\"}");
Console.WriteLine("{\"err\":\"success\", \"value\":\"C:\\data\"}");
```

二：

```csharp
Console.WriteLine("{\"err\":\"success\", \"value\":\"\u0043\u0023\u4e4b\u7236\u003a\u0020\u5b89\u5fb7\u65af\u00b7\u6d77\u5c14\u65af\u4f2f\u683c\"}");
```

三：

```csharp
Console.WriteLine(@"
{
    ""err"": ""success"",
    ""value"": ""C#之父: 安德斯·海尔斯伯格""
}
");
```

四：

```csharp
var msg = "success";
var value = "C#之父: 安德斯·海尔斯伯格";
Console.WriteLine($"{{\"err\":\"{msg}\", \"value\":\"{value}\"}}");
```

五：

```csharp
var msg = "success";
var value = "C#之父: 安德斯·海尔斯伯格";
Console.WriteLine($@"
{{
    ""err"": ""{msg}"",
    ""value"": ""{value}""
}}
");
```

六：

```csharp
var msg = "success";
var value = "C#之父: 安德斯·海尔斯伯格";
Console.WriteLine($@"
{
    "err": "{msg}",
    "value": "{value}"
}
");
```

七：

```csharp
var msg = "";
var value = "";
Console.WriteLine(@"
{
    "err": "success",
    "value": "C#之父: 安德斯·海尔斯伯格"
}
");
```

## 答案

```bash
一、二、三、四、五
```

### 选项

### A

```bash
一、二、三、四、六
```

### B

```bash
一、二、三、五、六
```

### C

```bash
二、三、四、五、七
```

### D

```bash
一、三、四、五、七
```
